<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Oferta Única MGA</title>
<link href="https://fonts.googleapis.com/css2?family=Anton&family=Montserrat:wght@700;900&family=Roboto:wght@400;700&display=swap" rel="stylesheet">
<style type="text/css">
    /* --- RESET --- */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    
    body, html {
        width: 100vw; height: 100vh; overflow: hidden;
        background: radial-gradient(circle at 30% 50%, #2a2a2a 0%, #000000 100%);
        font-family: 'Montserrat', 'Roboto', 'Arial', sans-serif;
    }

    /* LOGO FLUTUANTE */
    .logo-tv {
        position: absolute; top: 2vh; right: 2vw; height: 12vh; width: auto; z-index: 200;
        filter: drop-shadow(0 2px 5px rgba(0,0,0,0.5)); display: none;
        background: rgba(255,255,255,0.9); padding: 5px; border-radius: 10px;
    }

    /* CONTAINER PRINCIPAL */
    #tela-unica {
        width: 100%; height: 100%; display: flex; align-items: center; justify-content: center;
        padding: 4vh; transition: opacity 0.5s;
    }

    .produto-container {
        width: 100%; height: 100%; display: flex; flex-direction: row;
        align-items: center; justify-content: space-between;
    }

    /* ESQUERDA: IMAGEM */
    .area-img-left {
        width: 45%; height: 100%; display: flex; align-items: center; justify-content: center;
        position: relative;
    }
    .area-img-left img {
        max-width: 100%; max-height: 90%; object-fit: contain;
        filter: drop-shadow(15px 30px 40px rgba(0,0,0,0.8));
    }

    /* DIREITA: INFORMAÇÕES */
    .area-info-right {
        width: 55%; height: 100%; display: flex; flex-direction: column;
        justify-content: center; padding-left: 4vw; text-align: left;
    }

    .nome-prod-texto {
        font-size: 7vh; font-weight: 900; color: #ffffff; line-height: 1.1;
        text-transform: uppercase; margin-bottom: 2vh;
        display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden;
        text-shadow: 4px 4px 15px rgba(0,0,0,0.8);
    }

    .preco-container { display: flex; align-items: flex-start; line-height: 1; margin-top: 1vh; }
    .simbolo-moeda { font-size: 6vh; color: #ffc107; font-weight: 700; margin-top: 3vh; margin-right: 1vw; }
    .valor-gigante {
        font-family: 'Anton', 'Arial Black', sans-serif; font-size: 32vh; 
        color: #ffffff; letter-spacing: -0.05em;
        text-shadow: 8px 8px 30px rgba(0,0,0,0.9);
    }
    .unidade-medida { font-size: 5vh; color: #ffc107; font-weight: 700; align-self: flex-end; margin-bottom: 5vh; margin-left: 1vw; }

    /* VÍDEO */
    #video-container { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: black; z-index: 9999; display: none; align-items: center; justify-content: center; }
    video { width: 100%; height: 100%; object-fit: contain; }

    .loading-msg { color: rgba(255,255,255,0.4); font-size: 5vh; text-align: center; width: 100%; }
</style>
</head>
<body>

    <img id="img-logo-topo" class="logo-tv" src="">

    <div id="tela-unica">
        <div id="container-produto" style="width:100%; height:100%;">
            <div class="loading-msg">Carregando...</div>
        </div>
    </div>

    <div id="video-container">
        <video id="player" playsinline preload="auto"></video>
    </div>

    <script type="text/javascript">
        var API_URL = '../destaque-mercado.php';
        var TEMPO_TROCA = 8000; 
        var TEMPO_ATUALIZACAO = 60000;
        var LOOPS_PARA_COMERCIAL = 5; // A cada 5 produtos, vídeo
        
        var listaProdutos = [];
        var listaVideos = [];
        
        var idxProd = 0;
        var idxVideo = 0;
        var loops = 0;
        var timer = null;

        function formatarMoeda(val) {
            let v = parseFloat(String(val).replace(',', '.'));
            return isNaN(v) ? "0,00" : v.toFixed(2).replace('.', ',');
        }

        function baixarDados() {
            var uid = new URLSearchParams(window.location.search).get('uid') || 1;
            fetch(API_URL + '?uid=' + uid + '&t=' + Date.now())
                .then(r => r.json())
                .then(json => {
                    var dadosItens = [];
                    // Lógica Logo
                    if (json.itens) {
                        dadosItens = json.itens;
                        var logoEl = document.getElementById('img-logo-topo');
                        if (json.meta && json.meta.logo) {
                            logoEl.src = json.meta.logo; logoEl.style.display = 'block';
                        } else { logoEl.style.display = 'none'; }
                    } else { dadosItens = Array.isArray(json) ? json : []; }

                    listaVideos = dadosItens.filter(i => i.is_video == 1 || (i.imagem && i.imagem.match(/\.(mp4|webm)$/i)));
                    listaProdutos = dadosItens.filter(i => i.is_video != 1 && !(i.imagem && i.imagem.match(/\.(mp4|webm)$/i)));
                    
                    if (!timer && listaProdutos.length > 0) renderizar();
                })
                .catch(e => console.log(e));
        }

        function renderizar() {
            document.getElementById('video-container').style.display = 'none';
            document.getElementById('tela-unica').style.opacity = '1';
            document.getElementById('player').pause();

            var container = document.getElementById('container-produto');
            if (listaProdutos.length === 0) {
                if(listaVideos.length > 0) { rodarVideo(); return; }
                container.innerHTML = '<div class="loading-msg">Aguardando...</div>';
                timer = setTimeout(baixarDados, 3000); return;
            }

            if (idxProd >= listaProdutos.length) {
                idxProd = 0;
                loops++;
                if (loops >= LOOPS_PARA_COMERCIAL && listaVideos.length > 0) {
                    loops = 0; clearTimeout(timer); rodarVideo(); return;
                }
            }

            var item = listaProdutos[idxProd];
            var imgShow = 'https://cdn-icons-png.flaticon.com/512/3143/3143643.png'; 
            if (item.imagem && item.imagem.length > 5) {
                imgShow = item.imagem;
                if(!imgShow.includes('http') && !imgShow.startsWith('../')) imgShow = '../' + imgShow;
            }

            var html = `
            <div class="produto-container">
                <div class="area-img-left">
                    <img src="${imgShow}" onerror="this.src='https://cdn-icons-png.flaticon.com/512/3143/3143643.png'">
                </div>
                <div class="area-info-right">
                    <div class="nome-prod-texto">${item.produto}</div>
                    <div class="preco-container">
                        <div class="simbolo-moeda">R$</div>
                        <div class="valor-gigante">${formatarMoeda(item.preco)}</div>
                        <div class="unidade-medida">/${item.unidade || 'un'}</div>
                    </div>
                </div> 
            </div>`;

            container.style.opacity = 0;
            setTimeout(function(){
                container.innerHTML = html;
                container.style.opacity = 1;
            }, 200);
            
            idxProd++;
            timer = setTimeout(renderizar, TEMPO_TROCA);
        }

        function rodarVideo() {
            var itemVideo = listaVideos[idxVideo % listaVideos.length];
            var player = document.getElementById('player');
            
            document.getElementById('tela-unica').style.opacity = '0';
            document.getElementById('video-container').style.display = 'flex';
            
            var src = itemVideo.imagem;
            if(src && !src.includes('http') && !src.startsWith('../')) src = '../' + src;
            
            player.src = src;
            player.loop = false; player.currentTime = 0;
            player.muted = false;
            player.play().catch(() => { player.muted = true; player.play(); });

            var check = setTimeout(() => { if(player.readyState < 2) encerrarComercial(); }, 8000);
            player.onended = function() { clearTimeout(check); encerrarComercial(); };
            player.onerror = function() { clearTimeout(check); encerrarComercial(); };
        }

        function encerrarComercial() {
            var player = document.getElementById('player');
            player.pause(); player.removeAttribute('src'); player.load(); 
            idxVideo++;
            renderizar();
        }

        window.onload = function() { baixarDados(); setInterval(baixarDados, TEMPO_ATUALIZACAO); };
    </script>
</body>
</html>