<?php
// listar-galeria.php
header('Content-Type: application/json');

$dir = 'uploads/';
$arquivos = [];

// Verifica se a pasta existe
if (is_dir($dir)) {
    // Pega todos os arquivos da pasta
    $files = scandir($dir);
    
    foreach ($files as $file) {
        if ($file !== '.' && $file !== '..') {
            $caminhoCompleto = $dir . $file;
            $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
            
            // Aceita imagens e vídeos
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp', 'mp4', 'webm'])) {
                // Cria o array com data para ordenação (mais recentes primeiro)
                $arquivos[] = [
                    'nome' => $file,
                    'url'  => $caminhoCompleto,
                    'time' => filemtime($caminhoCompleto)
                ];
            }
        }
    }
    
    // Ordena do mais novo para o mais antigo
    usort($arquivos, function($a, $b) {
        return $b['time'] - $a['time'];
    });
}

echo json_encode($arquivos);
?>