<?php
require 'config.php'; // Adicione seu require 'lock.php' aqui se usar senha

$msg = "";

// DELETAR
if(isset($_GET['del'])){
    $id = (int)$_GET['del'];
    $stmt = $pdo->prepare("SELECT arquivo FROM comerciais WHERE id=?");
    $stmt->execute([$id]);
    $file = $stmt->fetchColumn();
    if($file && file_exists($file)) unlink($file);
    $pdo->prepare("DELETE FROM comerciais WHERE id=?")->execute([$id]);
    header("Location: gerenciar_videos.php"); exit;
}

// UPLOAD
if($_SERVER['REQUEST_METHOD']=='POST' && isset($_FILES['video'])){
    $titulo = $_POST['titulo'];
    if($_FILES['video']['error']===0){
        $ext = strtolower(pathinfo($_FILES['video']['name'], PATHINFO_EXTENSION));
        if(in_array($ext, ['mp4','webm'])){
            $nome = "video_".uniqid().".".$ext;
            if(!is_dir('uploads')) mkdir('uploads',0777,true);
            move_uploaded_file($_FILES['video']['tmp_name'], "uploads/".$nome);
            
            $pdo->prepare("INSERT INTO comerciais (titulo, arquivo) VALUES (?,?)")
                ->execute([$titulo, "uploads/".$nome]);
            $msg = "Vídeo salvo!";
        } else { $msg = "Apenas MP4 ou WEBM!"; }
    }
}

$videos = $pdo->query("SELECT * FROM comerciais ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4 bg-light">
<div class="container">
    <div class="d-flex justify-content-between mb-4">
        <h3>🎬 Comerciais TV</h3>
        <a href="painel.php" class="btn btn-secondary">Voltar</a>
    </div>
    
    <?php if($msg): ?><div class="alert alert-info"><?=$msg?></div><?php endif; ?>

    <div class="card p-3 mb-4">
        <form method="post" enctype="multipart/form-data">
            <div class="mb-2">
                <label>Título</label>
                <input type="text" name="titulo" class="form-control" required>
            </div>
            <div class="mb-2">
                <label>Arquivo MP4</label>
                <input type="file" name="video" class="form-control" accept="video/mp4" required>
            </div>
            <button class="btn btn-success w-100">Enviar Vídeo</button>
        </form>
    </div>

    <div class="row">
        <?php foreach($videos as $v): ?>
        <div class="col-md-4 mb-3">
            <div class="card">
                <video src="<?=$v['arquivo']?>" class="card-img-top" controls style="height:150px;object-fit:cover;background:#000"></video>
                <div class="card-body text-center">
                    <h6><?=$v['titulo']?></h6>
                    <a href="?del=<?=$v['id']?>" class="btn btn-danger btn-sm" onclick="return confirm('Apagar?')">Excluir</a>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>
</body>
</html>