<?php
// api_tv.php
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *");
header("Cache-Control: no-cache");

require 'config.php';

// Detecta URL do site
$protocolo = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
$base = $protocolo . "://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/";

try {
    // 1. PEGAR PRODUTOS
    $sqlProd = "SELECT produto, preco, unidade, imagem, destaque 
                FROM ofertas WHERE ativo=1 ORDER BY destaque DESC, id DESC";
    $produtos = $pdo->query($sqlProd)->fetchAll(PDO::FETCH_ASSOC);

    // Corrige URL Imagens
    foreach($produtos as $k => $v){
        if(!empty($v['imagem']) && strpos($v['imagem'], 'http')===false){
            $produtos[$k]['imagem'] = $base . $v['imagem'];
        }
    }

    // 2. PEGAR COMERCIAIS
    $sqlVid = "SELECT arquivo FROM comerciais WHERE ativo=1";
    $videos = $pdo->query($sqlVid)->fetchAll(PDO::FETCH_ASSOC);

    // Corrige URL Vídeos
    foreach($videos as $k => $v){
        if(!empty($v['arquivo']) && strpos($v['arquivo'], 'http')===false){
            $videos[$k]['arquivo'] = $base . $v['arquivo'];
        }
    }

    echo json_encode(['produtos' => $produtos, 'videos' => $videos]);

} catch(Exception $e) {
    echo json_encode(['produtos'=>[], 'videos'=>[]]);
}
?>