<?php
session_start();
require 'config.php';

// SEGURANÇA MÁXIMA: SÓ O ADMIN ENTRA AQUI
if (!isset($_SESSION['usuario_id']) || !isset($_SESSION['is_admin']) || $_SESSION['is_admin'] != 1) {
    die("ACESSO NEGADO. Você não é administrador.");
}

// --- AÇÃO 1: EDITAR USUÁRIO (POST) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao']) && $_POST['acao'] == 'editar_usuario') {
    $id_edit = (int)$_POST['id_usuario'];
    $empresa_edit = trim($_POST['nome_empresa']);
    $usuario_edit = trim($_POST['usuario_login']);
    $senha_edit = trim($_POST['nova_senha']);

    if (!empty($senha_edit)) {
        // Se digitou senha, atualiza tudo (incluindo senha criptografada)
        $hash = password_hash($senha_edit, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE usuarios SET nome_empresa = ?, usuario = ?, senha = ? WHERE id = ?");
        $stmt->execute([$empresa_edit, $usuario_edit, $hash, $id_edit]);
    } else {
        // Se senha está vazia, atualiza só os dados de texto
        $stmt = $pdo->prepare("UPDATE usuarios SET nome_empresa = ?, usuario = ? WHERE id = ?");
        $stmt->execute([$empresa_edit, $usuario_edit, $id_edit]);
    }
    header("Location: admin_master.php?msg=editado"); exit;
}

// --- AÇÃO 2: ATIVAR / BLOQUEAR / EXCLUIR (GET) ---
if (isset($_GET['acao']) && isset($_GET['id'])) {
    $idAlvo = (int)$_GET['id'];
    
    // Proteção para não se auto-bloquear
    if ($idAlvo == $_SESSION['usuario_id']) {
        header("Location: admin_master.php?msg=erro_proprio"); exit;
    }

    if ($_GET['acao'] == 'ativar') {
        $pdo->prepare("UPDATE usuarios SET ativo = 1 WHERE id = ?")->execute([$idAlvo]);
    }
    elseif ($_GET['acao'] == 'bloquear') {
        $pdo->prepare("UPDATE usuarios SET ativo = 0 WHERE id = ?")->execute([$idAlvo]);
    }
    elseif ($_GET['acao'] == 'deletar') {
        // Apaga produtos, categorias, filiais e o usuário
        $pdo->prepare("DELETE FROM ofertas WHERE usuario_id = ?")->execute([$idAlvo]);
        $pdo->prepare("DELETE FROM categorias WHERE usuario_id = ?")->execute([$idAlvo]);
        $pdo->prepare("DELETE FROM filiais WHERE usuario_id = ?")->execute([$idAlvo]);
        $pdo->prepare("DELETE FROM usuarios WHERE id = ?")->execute([$idAlvo]);
    }
    header("Location: admin_master.php"); exit;
}

// LISTAR USUÁRIOS
$usuarios = $pdo->query("SELECT * FROM usuarios ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Painel MESTRE - Administração</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
</head>
<body class="bg-dark text-white">

<nav class="navbar navbar-dark bg-danger shadow mb-4">
    <div class="container">
        <span class="navbar-brand fw-bold mb-0 h1"><i class="bi bi-shield-lock"></i> SUPER ADMIN</span>
        <div>
            <a href="painel.php" class="btn btn-outline-light me-2">Ir para Meu Painel</a>
            <a href="lock.php?sair=true" class="btn btn-light">Sair</a>
        </div>
    </div>
</nav>

<div class="container">
    
    <?php if(isset($_GET['msg']) && $_GET['msg']=='editado'): ?>
        <div class="alert alert-success alert-dismissible fade show text-dark">
            Dados do usuário atualizados com sucesso!
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card bg-secondary text-white shadow">
        <div class="card-header fw-bold d-flex justify-content-between align-items-center">
            <span>Gerenciamento de Clientes (SaaS)</span>
            <span class="badge bg-dark"><?= count($usuarios) ?> Clientes</span>
        </div>
        <div class="card-body bg-light text-dark p-0">
            <div class="table-responsive">
                <table class="table table-hover mb-0 align-middle">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Empresa / Usuário</th>
                            <th>Status</th>
                            <th>TV Link</th>
                            <th class="text-end">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach($usuarios as $u): 
                            $bg = $u['ativo'] ? '' : 'bg-warning bg-opacity-25';
                            $status = $u['ativo'] ? '<span class="badge bg-success">ATIVO</span>' : '<span class="badge bg-danger">BLOQUEADO</span>';
                            if($u['is_admin']) $status = '<span class="badge bg-dark">ADMIN</span>';
                            
                            // Escapar aspas para o Javascript não quebrar
                            $nomeJs = htmlspecialchars($u['nome_empresa'], ENT_QUOTES);
                            $userJs = htmlspecialchars($u['usuario'], ENT_QUOTES);
                        ?>
                        <tr class="<?= $bg ?>">
                            <td>#<?= $u['id'] ?></td>
                            <td>
                                <div class="fw-bold"><?= $u['nome_empresa'] ?></div>
                                <small class="text-muted"><i class="bi bi-person"></i> <?= $u['usuario'] ?></small>
                            </td>
                            <td><?= $status ?></td>
                            <td>
                                <a href="/tab/tv/tv.php?uid=<?= $u['id'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary" title="Ver Tabela"><i class="bi bi-tv"></i></a>
                            </td>
                                                        <td>
                                <a href="/tab/tv/tv141.php?uid=<?= $u['id'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary" title="Ver Encarte"><i class="bi bi-tv"></i></a>
                            </td>
                            <td>
                                <a href="/tab/tv/tv3ofp.php?uid=<?= $u['id'] ?>" target="_blank" class="btn btn-sm btn-outline-secondary" title="Ver Ofertas"><i class="bi bi-tv"></i></a>
                            </td>
                                                        <td class="text-end">
                                <button class="btn btn-sm btn-primary me-1" 
                                        onclick="abrirModalEditar(<?= $u['id'] ?>, '<?= $nomeJs ?>', '<?= $userJs ?>')" 
                                        title="Editar Dados e Senha">
                                    <i class="bi bi-pencil-square"></i>
                                </button>

                                <?php if(!$u['is_admin']): ?>
                                    <?php if($u['ativo']): ?>
                                        <a href="?acao=bloquear&id=<?= $u['id'] ?>" class="btn btn-sm btn-danger" title="Bloquear Acesso"><i class="bi bi-slash-circle"></i></a>
                                    <?php else: ?>
                                        <a href="?acao=ativar&id=<?= $u['id'] ?>" class="btn btn-sm btn-success" title="Aprovar/Liberar"><i class="bi bi-check-lg"></i></a>
                                    <?php endif; ?>
                                    
                                    <a href="?acao=deletar&id=<?= $u['id'] ?>" class="btn btn-sm btn-outline-danger ms-2" onclick="return confirm('ATENÇÃO: Isso apagará o cliente e TODOS os produtos dele. Continuar?')"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content text-dark">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title">Editar Cliente</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form method="POST">
                    <input type="hidden" name="acao" value="editar_usuario">
                    <input type="hidden" name="id_usuario" id="edit_id">
                    
                    <div class="mb-3">
                        <label class="form-label fw-bold">Nome da Empresa</label>
                        <input type="text" name="nome_empresa" id="edit_empresa" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label fw-bold">Usuário (Login)</label>
                        <input type="text" name="usuario_login" id="edit_usuario" class="form-control" required>
                    </div>

                    <hr>

                    <div class="mb-3 bg-light p-2 rounded border">
                        <label class="form-label fw-bold text-danger">Trocar Senha (Opcional)</label>
                        <input type="text" name="nova_senha" class="form-control" placeholder="Deixe em branco para manter a atual">
                        <small class="text-muted">Se preencher, a senha será alterada imediatamente.</small>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-success fw-bold">SALVAR ALTERAÇÕES</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    function abrirModalEditar(id, empresa, usuario) {
        // Preenche os campos do modal com os dados do usuário clicado
        document.getElementById('edit_id').value = id;
        document.getElementById('edit_empresa').value = empresa;
        document.getElementById('edit_usuario').value = usuario;
        
        // Abre o modal
        var myModal = new bootstrap.Modal(document.getElementById('modalEditar'));
        myModal.show();
    }
</script>
</body>
</html>