<?php
// Configurações de erro para facilitar o debug (pode remover depois se quiser)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// CREDENCIAIS DO BANCO
$host = 'localhost';
$db   = 'mgacom_ofertas';
$user = 'mgacom_ofertas';
$pass = 'Xs.0FUg-JwyI';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Erro na conexão com o banco: " . $e->getMessage());
}

// ATUALIZAR DADOS (Quando clica no botão)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Garante que existe o ID 1 antes de tentar atualizar
    // Se a tabela estiver vazia, ele cria o registro primeiro
    $check = $pdo->query("SELECT count(*) FROM oferta_destaque WHERE id = 1")->fetchColumn();
    
    if ($check == 0) {
        $sql = "INSERT INTO oferta_destaque (id, produto, preco, unidade) VALUES (1, ?, ?, ?)";
    } else {
        $sql = "UPDATE oferta_destaque SET produto = ?, preco = ?, unidade = ? WHERE id = 1";
    }
    
    $stmt = $pdo->prepare($sql);
    
    // Tratamento básico para vírgula no preço (se alguém digitar 19,90 vira 19.90)
    $precoFormatado = str_replace(',', '.', $_POST['preco']);
    
    $stmt->execute([$_POST['produto'], $precoFormatado, $_POST['unidade']]);
    $mensagem = "✅ Oferta atualizada com sucesso!";
}

// LER DADOS ATUAIS (Para preencher o formulário)
$stmt = $pdo->query("SELECT * FROM oferta_destaque WHERE id = 1");
$atual = $stmt->fetch(PDO::FETCH_ASSOC);

// Valores padrão caso o banco esteja vazio
if(!$atual) {
    $atual = ['produto' => '', 'preco' => '', 'unidade' => 'Un'];
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel de Ofertas TV</title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; padding: 20px; background: #e9ecef; }
        .box { background: white; max-width: 450px; margin: 40px auto; padding: 30px; border-radius: 10px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); }
        h2 { text-align: center; color: #333; margin-top: 0; }
        label { font-weight: bold; display: block; margin-top: 15px; color: #555; }
        input, select { width: 100%; padding: 12px; margin-top: 5px; border: 1px solid #ddd; border-radius: 5px; box-sizing: border-box; font-size: 16px; }
        input:focus, select:focus { border-color: #007bff; outline: none; }
        button { width: 100%; padding: 15px; margin-top: 25px; background: #28a745; color: white; border: none; border-radius: 5px; font-size: 18px; font-weight: bold; cursor: pointer; transition: background 0.3s; }
        button:hover { background: #218838; }
        .msg { background: #d4edda; color: #155724; padding: 10px; border-radius: 5px; text-align: center; margin-bottom: 20px; border: 1px solid #c3e6cb; }
    </style>
</head>
<body>

<div class="box">
    <h2>📺 Gerenciar Oferta</h2>
    
    <?php if(isset($mensagem)) echo "<div class='msg'>$mensagem</div>"; ?>

    <form method="POST">
        <label>Nome do Produto:</label>
        <input type="text" name="produto" value="<?= htmlspecialchars($atual['produto']) ?>" required placeholder="Ex: Alcatra Suína">

        <label>Preço (R$):</label>
        <input type="text" name="preco" value="<?= $atual['preco'] ?>" required placeholder="Ex: 29.90">

        <label>Unidade de Medida:</label>
        <select name="unidade">
            <option value="Kg" <?= $atual['unidade'] == 'Kg' ? 'selected' : '' ?>>Por Kg (/kg)</option>
            <option value="Un" <?= $atual['unidade'] == 'Un' ? 'selected' : '' ?>>Unidade (Un)</option>
            <option value="100g" <?= $atual['unidade'] == '100g' ? 'selected' : '' ?>>A cada 100g</option>
            <option value="Bdj" <?= $atual['unidade'] == 'Bdj' ? 'selected' : '' ?>>Bandeja</option>
            <option value="Pct" <?= $atual['unidade'] == 'Pct' ? 'selected' : '' ?>>Pacote</option>
        </select>

        <button type="submit">Atualizar na TV 🚀</button>
    </form>
</div>

</body>
</html>