<?php
// Permite acesso de qualquer lugar (necessário para o Xibo/CORS)
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

// CREDENCIAIS DO BANCO
$host = 'localhost';
$db   = 'mgacom_ofertas';
$user = 'mgacom_ofertas';
$pass = 'Xs.0FUg-JwyI';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    
    // Busca o produto de ID 1
    $stmt = $pdo->query("SELECT produto, preco, unidade FROM oferta_destaque WHERE id = 1");
    $oferta = $stmt->fetch(PDO::FETCH_ASSOC);

    if($oferta) {
        // Formata o preço: Troca ponto por vírgula para ficar padrão BR (ex: 19,90)
        $oferta['preco'] = number_format($oferta['preco'], 2, ',', '.');
        
        // Flags adicionais para o JS
        $oferta['ehDestaque'] = true;
        $oferta['textoBadge'] = 'Super Oferta';
        
        echo json_encode($oferta);
    } else {
        // Se não tiver nada no banco, retorna um JSON vazio "seguro"
        echo json_encode([
            'produto' => 'Aguarde...',
            'preco' => '--,--',
            'unidade' => '',
            'ehDestaque' => false
        ]);
    }

} catch (PDOException $e) {
    // Retorna erro em JSON para não quebrar o JS do Xibo
    http_response_code(500);
    echo json_encode(['erro' => 'Erro de conexão com banco de dados']);
}
?>