<?php
require 'config.php';
require 'auth.php';

// Processar Aprovação/Rejeição (Só Admin)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isAdmin()) {
    $troca_id = $_POST['troca_id'];
    $acao = $_POST['acao']; // aprovar ou rejeitar
    
    if ($acao === 'aprovar') {
        // 1. Busca dados da troca
        $t = $pdo->query("SELECT * FROM trocas WHERE id=$troca_id")->fetch();
        // 2. Atualiza o plantão original com o novo médico
        $stmt = $pdo->prepare("UPDATE plantoes SET profissional_id = ? WHERE id = ?");
        $stmt->execute([$t['substituto_id'], $t['plantao_id']]);
        // 3. Marca troca como aprovada
        $pdo->query("UPDATE trocas SET status='aprovado' WHERE id=$troca_id");
    } elseif ($acao === 'rejeitar') {
        $pdo->query("UPDATE trocas SET status='rejeitado' WHERE id=$troca_id");
    }
    header("Location: trocas.php"); exit;
}

// Listar Solicitações
$sql = "SELECT t.*, 
        p_orig.data_plantao, s.nome as sala_nome,
        prof_antigo.nome as nome_antigo,
        prof_novo.nome as nome_novo,
        usr.nome as solicitante
        FROM trocas t
        JOIN plantoes p_orig ON t.plantao_id = p_orig.id
        JOIN salas s ON p_orig.sala_id = s.id
        JOIN profissionais prof_antigo ON p_orig.profissional_id = prof_antigo.id -- Quem sai (antes de aprovar) ou saiu
        JOIN profissionais prof_novo ON t.substituto_id = prof_novo.id
        LEFT JOIN usuarios usr ON t.solicitante_id = usr.id
        ORDER BY t.data_solicitacao DESC";
$solicitacoes = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="pt-br" data-bs-theme="light">
<head>
    <meta charset="UTF-8">
    <title>Central de Trocas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style> body { background-color: #f4f6f9; } </style>
</head>
<body>
<div class="container mt-5">
    <div class="d-flex justify-content-between mb-4">
        <h3><i class="fa fa-exchange-alt"></i> Central de Trocas</h3>
        <a href="index.php" class="btn btn-secondary">Voltar</a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body p-0">
            <table class="table table-hover mb-0 align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Data Plantão</th>
                        <th>Sala</th>
                        <th>Sai (Atual)</th>
                        <th>Entra (Substituto)</th>
                        <th>Status</th>
                        <?php if(isAdmin()): ?> <th class="text-end">Ação</th> <?php endif; ?>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($solicitacoes as $s): ?>
                    <tr>
                        <td><?php echo date('d/m/Y', strtotime($s['data_plantao'])); ?></td>
                        <td><?php echo $s['sala_nome']; ?></td>
                        <td class="text-danger"><i class="fa fa-arrow-down"></i> <?php echo $s['nome_antigo']; ?></td>
                        <td class="text-success"><i class="fa fa-arrow-up"></i> <?php echo $s['nome_novo']; ?></td>
                        <td>
                            <?php 
                                if($s['status']=='pendente') echo '<span class="badge bg-warning text-dark">Pendente</span>';
                                elseif($s['status']=='aprovado') echo '<span class="badge bg-success">Aprovado</span>';
                                else echo '<span class="badge bg-danger">Rejeitado</span>';
                            ?>
                            <div class="small text-muted">Por: <?php echo $s['solicitante']; ?></div>
                        </td>
                        <?php if(isAdmin() && $s['status'] == 'pendente'): ?>
                        <td class="text-end">
                            <form method="POST" class="d-inline">
                                <input type="hidden" name="troca_id" value="<?php echo $s['id']; ?>">
                                <button type="submit" name="acao" value="aprovar" class="btn btn-sm btn-success" title="Aprovar"><i class="fa fa-check"></i></button>
                                <button type="submit" name="acao" value="rejeitar" class="btn btn-sm btn-danger" title="Rejeitar"><i class="fa fa-times"></i></button>
                            </form>
                        </td>
                        <?php elseif(isAdmin()): ?>
                        <td class="text-end text-muted">-</td>
                        <?php endif; ?>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php if(empty($solicitacoes)) echo "<p class='text-center p-3 text-muted'>Nenhuma solicitação de troca.</p>"; ?>
        </div>
    </div>
</div>
</body>
</html>