<?php
// fix_login.php
require 'config.php';

// Dados do Usuário que vamos criar/arrumar
$email = 'fran@hospital.com';
$senha_clara = '123456';
$nome = 'Recepção';
$nivel = 'visualizador'; // Opções: 'admin' ou 'visualizador'

// 1. Gera a senha criptografada correta para o SEU servidor
$senha_hash = password_hash($senha_clara, PASSWORD_DEFAULT);

try {
    // 2. Primeiro, verificamos se as colunas novas existem. Se não, criamos.
    // Isso previne erros se você esqueceu de rodar o SQL de atualização anterior.
    $colunas = $pdo->query("DESCRIBE usuarios")->fetchAll(PDO::FETCH_COLUMN);
    
    if (!in_array('nome', $colunas)) {
        $pdo->exec("ALTER TABLE usuarios ADD COLUMN nome VARCHAR(100) DEFAULT 'Usuário'");
        echo "Coluna 'nome' criada.<br>";
    }
    if (!in_array('nivel', $colunas)) {
        $pdo->exec("ALTER TABLE usuarios ADD COLUMN nivel ENUM('admin', 'visualizador') DEFAULT 'visualizador'");
        echo "Coluna 'nivel' criada.<br>";
    }

    // 3. Remove o usuário antigo se existir (para evitar duplicidade ou erro)
    $stmtDelete = $pdo->prepare("DELETE FROM usuarios WHERE email = ?");
    $stmtDelete->execute([$email]);

    // 4. Insere o usuário novo com a senha certa
    $sql = "INSERT INTO usuarios (email, senha, nome, nivel) VALUES (?, ?, ?, ?)";
    $stmtInsert = $pdo->prepare($sql);
    $stmtInsert->execute([$email, $senha_hash, $nome, $nivel]);

    echo "<div style='font-family:sans-serif; padding:20px; background:#e0f7fa; border:1px solid #00acc1; border-radius:5px;'>";
    echo "<h3 style='color:#006064; margin-top:0;'>✅ Usuário Recriado com Sucesso!</h3>";
    echo "Agora você pode logar com:<br>";
    echo "<strong>Email:</strong> $email<br>";
    echo "<strong>Senha:</strong> $senha_clara<br>";
    echo "<br><a href='login.php' style='background:#007bff; color:white; padding:10px; text-decoration:none; border-radius:5px;'>Ir para Login</a>";
    echo "</div>";

} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
?>