<?php
require 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id_oferta'] ?? '';
    
    // Recebe dados
    $produto = $_POST['produto'];
    $preco = $_POST['preco'];
    $formato = $_POST['formato'];
    $imagem_url = $_POST['imagem_url'];
    $logo_url = $_POST['logo_url'];
    $data_validade = empty($_POST['data_validade']) ? NULL : $_POST['data_validade'];
    $efeito_visual = $_POST['efeito_visual'] ?? 'normal';
    $bg_tipo = $_POST['bg_tipo'] ?? 'padrao';
    $bg_valor = ($bg_tipo === 'cor') ? $_POST['bg_cor_input'] : $_POST['bg_img_input'];
    
    // Extras e Posies
    $extra_texto = $_POST['extra_texto'];
    $extra_cor = $_POST['extra_cor'];
    $extra_tamanho = $_POST['extra_tamanho'];
    $logo_tamanho = $_POST['logo_tamanho'];
    $template_style = $_POST['template_style'] ?? 'classico';
    
    $img_pos_x = $_POST['img_pos_x']; $img_pos_y = $_POST['img_pos_y'];
    $extra_pos_x = $_POST['extra_pos_x']; $extra_pos_y = $_POST['extra_pos_y'];
    $logo_pos_x = $_POST['logo_pos_x']; $logo_pos_y = $_POST['logo_pos_y'];

    try {
        // 1. SALVA OU ATUALIZA A OFERTA
        if (!empty($id)) {
            $sql = "UPDATE ofertas SET 
                    produto=?, preco=?, formato=?, imagem_url=?, logo_url=?, data_validade=?, efeito_visual=?,
                    bg_tipo=?, bg_valor=?, extra_texto=?, extra_cor=?, extra_tamanho=?, logo_tamanho=?,
                    img_pos_x=?, img_pos_y=?, extra_pos_x=?, extra_pos_y=?, logo_pos_x=?, logo_pos_y=?,
                    template_style=?
                    WHERE id=?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $preco, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, 
                $bg_tipo, $bg_valor, $extra_texto, $extra_cor, $extra_tamanho, $logo_tamanho,
                $img_pos_x, $img_pos_y, $extra_pos_x, $extra_pos_y, $logo_pos_x, $logo_pos_y,
                $template_style, $id
            ]);
            $msg = "Oferta ATUALIZADA com sucesso!";
        } else {
            $sql = "INSERT INTO ofertas 
                    (produto, preco, formato, imagem_url, logo_url, data_validade, efeito_visual, bg_tipo, bg_valor, extra_texto, extra_cor, extra_tamanho, logo_tamanho, img_pos_x, img_pos_y, extra_pos_x, extra_pos_y, logo_pos_x, logo_pos_y, template_style) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $preco, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, $bg_tipo, $bg_valor, $extra_texto, $extra_cor, $extra_tamanho, $logo_tamanho, $img_pos_x, $img_pos_y, $extra_pos_x, $extra_pos_y, $logo_pos_x, $logo_pos_y, $template_style
            ]);
            $msg = "Oferta CRIADA com sucesso!";
        }

        // 2. ALIMENTA O BANCO DE NOMES (NOVO!)
        // O "INSERT IGNORE" tenta salvar. Se o nome j existir, ele no d erro, apenas ignora.
        if (!empty($produto)) {
            $sqlHist = "INSERT IGNORE INTO produtos_salvos (nome) VALUES (?)";
            $stmtHist = $pdo->prepare($sqlHist);
            $stmtHist->execute([trim($produto)]);
        }

        echo $msg;

    } catch (PDOException $e) {
        echo "Erro no banco: " . $e->getMessage();
    }
}
?>