<?php
require 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id_oferta'] ?? '';
    
    // Recebe todos os campos anteriores
    $produto = $_POST['produto'];
    $preco = $_POST['preco'];
    $formato = $_POST['formato'];
    $imagem_url = $_POST['imagem_url'];
    $logo_url = $_POST['logo_url'];
    $data_validade = empty($_POST['data_validade']) ? NULL : $_POST['data_validade'];
    $efeito_visual = $_POST['efeito_visual'] ?? 'normal';
    $bg_tipo = $_POST['bg_tipo'] ?? 'padrao';
    $bg_valor = ($bg_tipo === 'cor') ? $_POST['bg_cor_input'] : $_POST['bg_img_input'];
    
    $extra_texto = $_POST['extra_texto'];
    $extra_cor = $_POST['extra_cor'];
    $extra_tamanho = $_POST['extra_tamanho'];
    $logo_tamanho = $_POST['logo_tamanho'];
    
    // Posies
    $img_pos_x = $_POST['img_pos_x']; $img_pos_y = $_POST['img_pos_y'];
    $extra_pos_x = $_POST['extra_pos_x']; $extra_pos_y = $_POST['extra_pos_y'];
    $logo_pos_x = $_POST['logo_pos_x']; $logo_pos_y = $_POST['logo_pos_y'];

    // --- NOVO CAMPO: TEMPLATE ---
    $template_style = $_POST['template_style'] ?? 'classico';

    try {
        if (!empty($id)) {
            $sql = "UPDATE ofertas SET 
                    produto=?, preco=?, formato=?, imagem_url=?, logo_url=?, data_validade=?, efeito_visual=?,
                    bg_tipo=?, bg_valor=?, extra_texto=?, extra_cor=?, extra_tamanho=?, logo_tamanho=?,
                    img_pos_x=?, img_pos_y=?, extra_pos_x=?, extra_pos_y=?, logo_pos_x=?, logo_pos_y=?,
                    template_style=?
                    WHERE id=?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $preco, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, 
                $bg_tipo, $bg_valor, $extra_texto, $extra_cor, $extra_tamanho, $logo_tamanho,
                $img_pos_x, $img_pos_y, $extra_pos_x, $extra_pos_y, $logo_pos_x, $logo_pos_y,
                $template_style, $id
            ]);
            echo "Atualizado com sucesso!";
        } else {
            $sql = "INSERT INTO ofertas 
                    (produto, preco, formato, imagem_url, logo_url, data_validade, efeito_visual, bg_tipo, bg_valor, extra_texto, extra_cor, extra_tamanho, logo_tamanho, img_pos_x, img_pos_y, extra_pos_x, extra_pos_y, logo_pos_x, logo_pos_y, template_style) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $preco, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, $bg_tipo, $bg_valor, $extra_texto, $extra_cor, $extra_tamanho, $logo_tamanho, $img_pos_x, $img_pos_y, $extra_pos_x, $extra_pos_y, $logo_pos_x, $logo_pos_y,
                $template_style
            ]);
            echo "Criado com sucesso!";
        }
    } catch (PDOException $e) { echo "Erro: " . $e->getMessage(); }
}
?>