<?php
require 'conexao.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id_oferta'] ?? '';
    
    // Recebendo todos os campos
    $produto = $_POST['produto'];
    $preco = $_POST['preco'];
    $formato = $_POST['formato'];
    $imagem_url = $_POST['imagem_url'];
    $logo_url = $_POST['logo_url'];
    $data_validade = empty($_POST['data_validade']) ? NULL : $_POST['data_validade'];
    $efeito_visual = $_POST['efeito_visual'] ?? 'normal';
    
    // Background
    $bg_tipo = $_POST['bg_tipo'] ?? 'padrao';
    $bg_valor = ($bg_tipo === 'cor') ? $_POST['bg_cor_input'] : $_POST['bg_img_input'];

    // Posies e Texto Extra
    $img_pos_x = $_POST['img_pos_x'] ?? 'center';
    $img_pos_y = $_POST['img_pos_y'] ?? 'center';
    
    $extra_texto = $_POST['extra_texto'] ?? '';
    $extra_cor = $_POST['extra_cor'] ?? '#ffffff';
    $extra_tamanho = $_POST['extra_tamanho'] ?? 40;
    $extra_pos_x = $_POST['extra_pos_x'] ?? 'center';
    $extra_pos_y = $_POST['extra_pos_y'] ?? 'center';

    // --- NOVOS CAMPOS DA LOGO ---
    $logo_tamanho = $_POST['logo_tamanho'] ?? 100;
    $logo_pos_x = $_POST['logo_pos_x'] ?? 'default';
    $logo_pos_y = $_POST['logo_pos_y'] ?? 'default';

    try {
        if (!empty($id)) {
            // UPDATE
            $sql = "UPDATE ofertas SET 
                    produto=?, preco=?, formato=?, imagem_url=?, logo_url=?, data_validade=?, efeito_visual=?,
                    bg_tipo=?, bg_valor=?,
                    img_pos_x=?, img_pos_y=?, 
                    extra_texto=?, extra_cor=?, extra_tamanho=?, extra_pos_x=?, extra_pos_y=?,
                    logo_tamanho=?, logo_pos_x=?, logo_pos_y=?
                    WHERE id=?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $preco, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, 
                $bg_tipo, $bg_valor,
                $img_pos_x, $img_pos_y, 
                $extra_texto, $extra_cor, $extra_tamanho, $extra_pos_x, $extra_pos_y,
                $logo_tamanho, $logo_pos_x, $logo_pos_y,
                $id
            ]);
            echo "Oferta ATUALIZADA com sucesso!";
        } else {
            // INSERT
            $sql = "INSERT INTO ofertas 
                    (produto, preco, formato, imagem_url, logo_url, data_validade, efeito_visual, bg_tipo, bg_valor, img_pos_x, img_pos_y, extra_texto, extra_cor, extra_tamanho, extra_pos_x, extra_pos_y, logo_tamanho, logo_pos_x, logo_pos_y) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $produto, $preco, $formato, $imagem_url, $logo_url, $data_validade, $efeito_visual, $bg_tipo, $bg_valor,
                $img_pos_x, $img_pos_y, $extra_texto, $extra_cor, $extra_tamanho, $extra_pos_x, $extra_pos_y,
                $logo_tamanho, $logo_pos_x, $logo_pos_y
            ]);
            echo "Oferta CRIADA com sucesso!";
        }
    } catch (PDOException $e) {
        echo "Erro no banco: " . $e->getMessage();
    }
}
?>