<?php
// buscador.php
header('Content-Type: application/json');

// Aumenta o tempo limite caso a internet esteja lenta
ini_set('max_execution_time', 60);

$termo = $_GET['termo'] ?? '';

if (empty($termo)) {
    echo json_encode([]);
    exit;
}

// 1. Melhora o termo de busca adicionando "png"
$query = urlencode($termo);

// 2. Monta a URL do Bing com o FILTRO DE TRANSPAR08NCIA
// &qft=+filterui:photo-transparent -> Esse  o segredo para vir sem fundo
$url = "https://www.bing.com/images/search?q=$query&form=HDRSC2&first=1&qft=+filterui:photo-transparent";

// Configura o cURL para parecer um navegador real
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
// User agent moderno para evitar bloqueios
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
$html = curl_exec($ch);
curl_close($ch);

$imagens = [];

if ($html) {
    // Regex para pegar URLs de imagens (murl)
    // O Bing entrega a URL real dentro de um JSON no HTML
    preg_match_all('/murl&quot;:&quot;(.*?)&quot;/', $html, $matches);
    
    if (!empty($matches[1])) {
        // Pega at 20 imagens
        $urls = array_slice($matches[1], 0, 20);
        foreach ($urls as $link) {
            $limpo = html_entity_decode($link);
            
            // Valida se  um link de imagem vlido
            if (filter_var($limpo, FILTER_VALIDATE_URL)) {
                // Tenta filtrar extens01es que geralmente n00o s00o transparentes (opcional)
                // mas o filtro do Bing j faz o trabalho pesado.
                $imagens[] = $limpo;
            }
        }
    }
}

echo json_encode($imagens);
?>