<?php
// api.php
// Cabeçalhos ANTI-CACHE (Obrigatório para Digital Signage)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");
header('Content-Type: application/json');
header("Access-Control-Allow-Origin: *"); 

require 'conexao.php';

$modo = $_GET['modo'] ?? 'landscape';

try {
    // Busca ofertas válidas
    $sql = "SELECT * FROM ofertas 
            WHERE formato = ? 
            AND (data_validade >= CURDATE() OR data_validade IS NULL OR data_validade = '0000-00-00')
            ORDER BY id DESC LIMIT 20";
            
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$modo]);
    
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
} catch (PDOException $e) {
    echo json_encode(['erro' => $e->getMessage()]);
}
?>