<?php
require 'conexao.php';
header('Content-Type: application/json');
// Aumenta tempo para download de imagens pesadas
ini_set('max_execution_time', 120); 

$acao = $_POST['acao'] ?? $_GET['acao'] ?? '';

// --- 1. LISTAR IMAGENS ---
if ($acao == 'listar') {
    $busca = $_GET['busca'] ?? '';
    $sql = "SELECT * FROM banco_imagens WHERE nome_arquivo LIKE ? ORDER BY id DESC";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(["%$busca%"]);
    echo json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
    exit;
}

// --- 2. UPLOAD LOCAL ---
if ($acao == 'upload') {
    if (isset($_FILES['arquivo'])) {
        $ext = strtolower(pathinfo($_FILES['arquivo']['name'], PATHINFO_EXTENSION));
        $permitidos = ['jpg', 'jpeg', 'png', 'webp'];

        if (in_array($ext, $permitidos)) {
            $novoNome = uniqid() . "." . $ext;
            if (!is_dir('uploads')) mkdir('uploads', 0777, true);
            $destino = 'uploads/' . $novoNome;

            if (move_uploaded_file($_FILES['arquivo']['tmp_name'], $destino)) {
                $nomeOriginal = pathinfo($_FILES['arquivo']['name'], PATHINFO_FILENAME);
                $stmt = $pdo->prepare("INSERT INTO banco_imagens (nome_arquivo, caminho) VALUES (?, ?)");
                $stmt->execute([$nomeOriginal, $destino]);
                echo json_encode(['sucesso' => true, 'msg' => 'Imagem salva!']);
            } else { echo json_encode(['sucesso' => false, 'msg' => 'Erro ao mover arquivo.']); }
        } else { echo json_encode(['sucesso' => false, 'msg' => 'Formato inválido.']); }
    }
    exit;
}

// --- 3. EXCLUIR ---
if ($acao == 'excluir') {
    $id = $_POST['id'] ?? '';
    if($id) {
        $stmt = $pdo->prepare("SELECT caminho FROM banco_imagens WHERE id = ?");
        $stmt->execute([$id]);
        $imagem = $stmt->fetch(PDO::FETCH_ASSOC);
        if($imagem) {
            if(file_exists($imagem['caminho'])) unlink($imagem['caminho']);
            $del = $pdo->prepare("DELETE FROM banco_imagens WHERE id = ?");
            $del->execute([$id]);
            echo json_encode(['sucesso' => true, 'msg' => 'Excluído.']);
        } else { echo json_encode(['sucesso' => false, 'msg' => 'Não encontrado.']); }
    }
    exit;
}

// --- 4. SALVAR URL (COM NOME DO PRODUTO) ---
if ($acao == 'salvar_url') {
    $url = $_POST['url'] ?? '';
    $nomeProduto = $_POST['nome'] ?? 'imagem_web'; // Recebe o nome do produto
    
    if (filter_var($url, FILTER_VALIDATE_URL)) {
        $conteudo = @file_get_contents($url);
        
        if ($conteudo) {
            if (!is_dir('uploads')) mkdir('uploads', 0777, true);
            
            // Limpa o nome para virar nome de arquivo (remove acentos e espaços)
            $nomeLimpo = preg_replace('/[^a-z0-9]+/', '_', strtolower(iconv('UTF-8', 'ASCII//TRANSLIT', $nomeProduto)));
            // Adiciona um ID único para não sobrescrever se tiver nomes iguais
            $nomeArquivo = $nomeLimpo . '_' . uniqid() . '.png'; // Salva como PNG para garantir
            
            $destino = 'uploads/' . $nomeArquivo;
            
            if (file_put_contents($destino, $conteudo)) {
                // Salva no banco com o NOME BONITO (Ex: Sabão Omo)
                $stmt = $pdo->prepare("INSERT INTO banco_imagens (nome_arquivo, caminho) VALUES (?, ?)");
                $stmt->execute([$nomeProduto, $destino]);
                
                echo json_encode(['sucesso' => true, 'msg' => 'Salvo como: ' . $nomeProduto, 'caminho' => $destino]);
            } else { echo json_encode(['sucesso' => false, 'msg' => 'Erro de disco.']); }
        } else { echo json_encode(['sucesso' => false, 'msg' => 'Erro ao baixar. URL protegida?']); }
    } else { echo json_encode(['sucesso' => false, 'msg' => 'URL inválida.']); }
    exit;
}
// ... (códigos anteriores: listar, upload, excluir, salvar_url) ...

// --- 5. RENOMEAR IMAGEM (NOVO) ---
if ($acao == 'renomear') {
    $id = $_POST['id'] ?? '';
    $novoNome = $_POST['nome'] ?? '';

    if ($id && $novoNome) {
        try {
            $sql = "UPDATE banco_imagens SET nome_arquivo = ? WHERE id = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$novoNome, $id]);
            echo json_encode(['sucesso' => true, 'msg' => 'Renomeado com sucesso!']);
        } catch (PDOException $e) {
            echo json_encode(['sucesso' => false, 'msg' => 'Erro ao atualizar banco.']);
        }
    } else {
        echo json_encode(['sucesso' => false, 'msg' => 'Dados inválidos.']);
    }
    exit;
}
?>