<?php
// buscador.php
header('Content-Type: application/json');
// Ignora erros para n00o sujar o JSON
error_reporting(0); 

$termo = $_GET['termo'] ?? '';

if (empty($termo)) {
    echo json_encode([]);
    exit;
}

// 1. Termo de busca otimizado para produtos transparentes
$query = urlencode($termo . " transparent png");

// 2. URL do Bing com filtros (Transparente + Imagens Grandes)
// O segredo: 'qft=+filterui:photo-transparent'
$url = "https://www.bing.com/images/search?q=$query&form=HDRSC2&first=1&qft=+filterui:photo-transparent";

// 3. Configura0400o Avan04ada de "Disfarce" (User-Agent)
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 15);

// User-Agent de um PC comum (Chrome no Windows)
curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36');

$html = curl_exec($ch);
curl_close($ch);

$imagens = [];

if ($html) {
    // --- ESTRAT07GIA 1: Padr00o JSON (murl) ---
    // O Bing costuma esconder o link real dentro de um atributo murl
    preg_match_all('/murl&quot;:&quot;(.*?)&quot;/', $html, $matches1);
    
    // --- ESTRAT07GIA 2: Padr00o HTML Direto (src) ---
    // Caso a estratgia 1 falhe, tenta pegar links diretos
    preg_match_all('/src="(http[^"]+)"/', $html, $matches2);

    // Junta tudo
    $candidatos = array_merge($matches1[1] ?? [], $matches2[1] ?? []);
    
    // Filtra os resultados
    foreach ($candidatos as $link) {
        // Decodifica URL (ex: transforma %2F em /)
        $link = html_entity_decode($link);
        $link = urldecode($link);

        // Remove imagens pequenas, cones do Bing ou scripts
        if (strpos($link, 'bing.com') !== false) continue; // Pula imagens hospedadas no prprio Bing (geralmente thumbs ou logos)
        if (strpos($link, '.svg') !== false) continue;
        if (strpos($link, '.gif') !== false) continue;
        
        // Verifica se parece uma URL vlida
        if (filter_var($link, FILTER_VALIDATE_URL)) {
            $imagens[] = $link;
        }
    }
    
    // Remove duplicadas e pega as 20 primeiras
    $imagens = array_values(array_unique($imagens));
    $imagens = array_slice($imagens, 0, 20);
}

// Se depois de tudo a lista estiver vazia, retorna array vazio []
// (Isso evita mostrar "imagem quebrada" no front-end)
echo json_encode($imagens);
?>